package gov.va.med.domain.service.messaging.handler;

import gov.va.med.framework.exception.CoreException;

/**
 * Thrown by MessageHandlers to signal a recoverable error occured that 
 * warrants retying later, such as a unavailable database connection 
 * or remote site unavailable. 
 * @author Slave Uchitel 
 * @version $Id: RecoverableHandlerException.java,v 1.4 2005/09/12 21:18:17 slava.uchitel Exp $
 * @since
 */
public class RecoverableHandlerException extends RuntimeException {

	 private static final long serialVersionUID = 3256442512536514868L;

	    public RecoverableHandlerException() {
	        super();
	    }

	    public RecoverableHandlerException(String s) {
	        super(s);
	    }

	    public RecoverableHandlerException(Throwable throwable) {
	        super(throwable);
	    }

	    public RecoverableHandlerException(String s, Throwable throwable) {
	        super(s, throwable);
	    }
}
